attribute vec3 coord;

attribute vec2 texcoord;
varying vec2 f_texcoord;
varying float f_alpha;

#ifdef INSTANCING
attribute vec4 translate_and_factor;
#else
uniform vec4 translate_and_factor;
#endif

uniform mat4 vp;

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
uniform mat4 v;
#endif

uniform vec3 cam_right;
uniform vec3 cam_up;

void main(void)
{
	vec3 translate = translate_and_factor.xyz;
	vec3 posBillboard = translate + cam_right*coord.x + cam_up*coord.y;
	vec4 positionWorld = vec4(posBillboard, 1.0);
	gl_Position = vp * positionWorld;

	f_texcoord = texcoord;
	f_alpha = translate_and_factor.a;

#ifdef FOG
	f_fogFactor = getFogFactor(v, positionWorld);
	f_fogFactorGround = getFogFactorGround(f_fogFactor, positionWorld);
#endif
}
